/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

public class PresetFrame
extends Frame
implements ActionListener,
ItemListener {
    Choice letter;
    Choice contrast;
    Button select;
    protected final String SEPARATOR = ".";
    protected final String EXTENSION = ".dat";
    String[] availableSources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "sq", "sq2"};
    String[] availableBackgrounds = new String[]{"orig", "contr", "hi", "noisy"};
    String[][] translations = new String[][]{{"hi", "Low Contrast"}, {"contr", "High Contrast"}, {"orig", "Highest Contrast"}, {"noisy", "Noisy Data"}, {"sq", "Solid Square"}, {"sq2", "Hollow Square"}};
    Hashtable translationHash;

    public PresetFrame() {
        super("LimSim - Load Preset Matrix");
        ((Component)this).setBackground(Color.white);
        this.initializeTranslations();
        this.letter = new Choice();
        int i = 0;
        while (i < this.availableSources.length) {
            this.letter.add(this.getTranslation(this.availableSources[i]));
            ++i;
        }
        this.contrast = new Choice();
        this.letter.select(0);
        this.setChoiceForSource(0);
        this.letter.addItemListener(this);
        this.select = new Button(" Load ");
        this.select.addActionListener(this);
        this.addWindowListener(new 1());
        this.setLayout(new FlowLayout());
        this.add(new Label("  Shape:  "));
        this.add(this.letter);
        this.add(new Label("  Background:  "));
        this.add(this.contrast);
        this.add(new Label("    "));
        this.add(this.select);
        Rectangle parentBounds = LimSim.topLevelContainer.getBounds();
        ((Component)this).setLocation(parentBounds.x + 40, parentBounds.y + 40);
        this.pack();
    }

    public void actionPerformed(ActionEvent ae) {
        this.setNewValues();
        this.close();
    }

    public void itemStateChanged(ItemEvent ie) {
        int selected = this.letter.getSelectedIndex();
        this.setChoiceForSource(selected);
    }

    protected void setChoiceForSource(int source) {
        this.contrast.removeAll();
        int i = 0;
        while (i < this.availableBackgrounds.length) {
            if (!(source == 2 && i == 3 || source == 7 && i == 2 || source == 9 && (i == 0 || i == 3))) {
                this.contrast.add(this.getTranslation(this.availableBackgrounds[i]));
            }
            ++i;
        }
        this.repaint();
    }

    protected void initializeTranslations() {
        this.translationHash = new Hashtable();
        int i = 0;
        while (i < this.translations.length) {
            this.translationHash.put(this.translations[i][0], this.translations[i][1]);
            ++i;
        }
    }

    protected String getTranslation(String key) {
        String trans = key;
        if (this.translationHash.containsKey(key)) {
            trans = (String)this.translationHash.get(key);
        }
        return trans;
    }

    protected void setNewValues() {
        String source = this.letter.getSelectedItem();
        String backgr = this.contrast.getSelectedItem();
        int i = 0;
        while (i < this.translations.length) {
            if (source.equals(this.translations[i][1])) {
                source = this.translations[i][0];
            }
            if (backgr.equals(this.translations[i][1])) {
                backgr = this.translations[i][0];
            }
            ++i;
        }
        String newFile = String.valueOf(source) + "." + backgr + ".dat";
        String newFilePath = LimSim.dataFilePath.startsWith("http") ? String.valueOf(LimSim.dataFilePath.substring(0, LimSim.dataFilePath.lastIndexOf("/") + 1)) + newFile : String.valueOf(LimSim.dataFilePath.substring(0, LimSim.dataFilePath.lastIndexOf(File.separator) + 1)) + newFile;
        try {
            CellMatrix newMatrix = new CellMatrix(newFilePath);
            LimSim.display.setModel(newMatrix);
            LimSim.initMatrix = newMatrix;
            LimSim.processedMatrix = null;
            LimSim.processed = false;
            LimSim.OK.setLabel("  OK  ");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Unable to load file.");
        }
    }

    public void close() {
        LimSim.enableInput(true);
        ((Component)this).setVisible(false);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            PresetFrame.this.close();
        }

        /* synthetic */ 1() {
        }
    }
}

