/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class FileLoader {
    private String fileName;
    private DataInputStream filteredIn;

    public FileLoader(String name) {
        this.fileName = name;
    }

    public FileLoader() {
    }

    public boolean openFile() {
        boolean result = true;
        try {
            if (this.fileName.startsWith("http")) {
                URL inputFile = new URL(this.fileName);
                this.filteredIn = new DataInputStream(inputFile.openStream());
            } else {
                File inputFile = new File(this.fileName);
                FileInputStream fis = new FileInputStream(inputFile);
                this.filteredIn = new DataInputStream(fis);
            }
        }
        catch (MalformedURLException e) {
            System.out.println(e);
            result = false;
        }
        catch (IOException e) {
            System.out.println(e);
            result = false;
        }
        return result;
    }

    public Float[] loadVector(String file) {
        this.fileName = file;
        if (!this.openFile()) {
            return null;
        }
        boolean exit = false;
        String buffer = "";
        Object I = null;
        int index = 0;
        Float[] limVector = new Float[400];
        while (!exit) {
            try {
                char input = (char)this.filteredIn.readByte();
                Character inputChar = new Character(input);
                if (input != ' ') {
                    buffer = String.valueOf(buffer) + inputChar.charValue();
                    continue;
                }
                limVector[index] = new Float(buffer);
                buffer = "";
                ++index;
            }
            catch (IOException iOException) {
                exit = true;
            }
        }
        return limVector;
    }

    public Float[] loadVector() {
        return this.fileName == null ? null : this.loadVector(this.fileName);
    }
}

