/*
 * Decompiled with CFR 0.152.
 */
public class CellMatrix {
    private Float[] limArray;
    private CellMatrix[] weights;
    private String name;
    private FileLoader input;

    public CellMatrix(String fileName) {
        this.input = new FileLoader(fileName);
        this.limArray = this.input.loadVector(fileName);
        this.name = fileName;
    }

    public CellMatrix() {
        this.limArray = null;
        this.name = "";
    }

    public CellMatrix(int size) {
        this.limArray = new Float[size];
        int i = 0;
        while (i < size) {
            this.limArray[i] = new Float(0.0f);
            ++i;
        }
        int i2 = 0;
        while (i2 < size) {
            this.setWeightMatrix(i2, this);
            ++i2;
        }
        this.name = "";
    }

    public void loadMatrix(String fileName) {
        this.input = new FileLoader(fileName);
        this.limArray = this.input.loadVector(fileName);
        this.name = fileName;
    }

    public void dumpVector() {
        int foo = 0;
        while (foo < this.limArray.length) {
            System.out.print(String.valueOf(this.limArray[foo]) + " ");
            ++foo;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.limArray == null ? 0 : this.limArray.length;
    }

    public int getDimension() {
        if (this.limArray == null) {
            return 0;
        }
        double intSize = new Integer(this.limArray.length).doubleValue();
        return new Double(Math.sqrt(this.limArray.length)).intValue();
    }

    public void setCellValue(int cellNumber, Float value) {
        this.limArray[cellNumber] = value;
    }

    public void setCells(Float[] array) {
        this.limArray = array;
    }

    public CellMatrix getWeightMatrix(int cellNumber) {
        return this.weights[cellNumber];
    }

    public void setWeightMatrix(int cellNumber, CellMatrix newWeights) {
        if (this.weights == null) {
            this.weights = new CellMatrix[this.getSize()];
        }
        if (newWeights.getSize() != this.limArray.length) {
            return;
        }
        this.weights[cellNumber] = newWeights;
    }

    public int[] getIntegerRepresentation() {
        int[] matrix = new int[this.limArray.length];
        if (this.limArray == null) {
            return null;
        }
        int index = 0;
        while (index < this.limArray.length) {
            matrix[index] = 4 - Math.round(this.limArray[index].floatValue() * 4.0f);
            ++index;
        }
        return matrix;
    }

    public void setCellValue(int position, int value, int shades) {
        if (this.limArray == null || position > this.limArray.length) {
            return;
        }
        float fValue = value;
        float fShades = shades;
        this.setCellValue(position, new Float(1.0f - fValue / fShades));
    }

    public void setCellValue(int position, int value) {
        this.setCellValue(position, value, 4);
    }

    public int intCellAt(int position) {
        return this.intCellAt(position, 4);
    }

    public int intCellAt(int position, int shades) {
        if (this.limArray == null || position > this.limArray.length) {
            return 0;
        }
        return shades - Math.round(this.limArray[position].floatValue() * (float)shades);
    }

    public float floatCellAt(int position) {
        if (this.limArray == null || position > this.limArray.length) {
            return 0.0f;
        }
        return this.limArray[position].floatValue();
    }
}

